/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.util.config.Config;
import me.keehl.elevators.util.config.ElevatorsRepresenter;
import me.keehl.elevators.util.config.converter.ArrayConfigConverter;
import me.keehl.elevators.util.config.converter.ConfigConfigConverter;
import me.keehl.elevators.util.config.converter.EnumConfigConverter;
import me.keehl.elevators.util.config.converter.ListConfigConverter;
import me.keehl.elevators.util.config.converter.MapConfigConverter;
import me.keehl.elevators.util.config.converter.MaterialConfigConverter;
import me.keehl.elevators.util.config.converter.NamespacedKeyConfigConverter;
import me.keehl.elevators.util.config.converter.PrimitiveConfigConverter;
import me.keehl.elevators.util.config.converter.RecipeRowConfigConverter;
import me.keehl.elevators.util.config.converter.SetConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigRootNode;
import me.keehl.elevators.util.config.nodes.DirectConfigNode;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

public abstract class ConfigConverter {
    private static final LinkedHashSet<ConfigConverter> converters = new LinkedHashSet();
    private static Yaml yaml;

    public static void addConverter(Class<? extends ConfigConverter> clazz) throws Exception {
        if (!ConfigConverter.class.isAssignableFrom(clazz)) {
            throw new Exception("Converter does not implement the Interface Converter");
        }
        try {
            converters.add(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new Exception("Converter does not implement an accessible Constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new Exception("Converter could not be invoked", e);
        }
        catch (InstantiationException e) {
            throw new Exception("Converter could not be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Converter does not implement a public Constructor which takes the InternalConverter instance", e);
        }
    }

    public static <T extends Config> ConfigRootNode<T> createNodeForConfigData(T config, Map<?, ?> yamlData) throws Exception {
        Optional<ConfigConverter> optConverter = converters.stream().filter(i -> i.supports(config.getClass())).findAny();
        if (!optConverter.isPresent()) {
            return null;
        }
        ConfigConverter converter = optConverter.get();
        if (converter instanceof ConfigConfigConverter) {
            ConfigConfigConverter ccc = (ConfigConfigConverter)converter;
            ConfigRootNode<T> root = new ConfigRootNode<T>(yamlData == null ? new HashMap() : yamlData, config);
            config.setKey("root");
            ccc.constructMapToConfig(root, root, config, new FieldData(null, config.getClass(), config.getClass()));
            config.onLoad();
            return root;
        }
        return null;
    }

    public static <T extends Config> ConfigRootNode<T> createNodeForConfig(T config, InputStream inputStream) throws Exception {
        Map yamlData;
        try (InputStreamReader fileReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            yamlData = (Map)yaml.load((Reader)fileReader);
        }
        catch (IOException | ClassCastException | YAMLException e) {
            throw new Exception("Could not load YML", e);
        }
        return ConfigConverter.createNodeForConfigData(config, yamlData);
    }

    public static <T extends Config> ConfigRootNode<T> createNodeForConfig(T config, File file) throws Exception {
        return ConfigConverter.createNodeForConfig(config, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveConfigToFile(ConfigRootNode<?> node, File file) {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            int depth = 0;
            ArrayList<String> keyChain = new ArrayList<String>();
            String yamlString = yaml.dump(node.serializeToObject());
            StringBuilder writeLines = new StringBuilder();
            for (String line : yamlString.split("\n")) {
                if (line.startsWith(new String(new char[depth]).replace("\u0000", " "))) {
                    keyChain.add(line.split(":")[0].trim());
                    depth += 2;
                } else {
                    if (line.startsWith(new String(new char[depth - 2]).replace("\u0000", " "))) {
                        keyChain.remove(keyChain.size() - 1);
                    } else {
                        int spaces = 0;
                        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++spaces, ++i) {
                        }
                        depth = spaces;
                        if (spaces == 0) {
                            keyChain = new ArrayList();
                            depth = 2;
                        } else {
                            ArrayList<String> temp = new ArrayList<String>();
                            int index = 0;
                            for (int i = 0; i < spaces; i += 2, ++index) {
                                temp.add(keyChain.get(index));
                            }
                            keyChain = temp;
                            depth += 2;
                        }
                    }
                    keyChain.add(line.split(":")[0].trim());
                }
                String search = ConfigConverter.join(keyChain);
                for (String comment : node.getCommentsAtPath(search)) {
                    writeLines.append(new String(new char[depth - 2]).replace("\u0000", " "));
                    writeLines.append("# ");
                    writeLines.append(comment);
                    writeLines.append("\n");
                }
                writeLines.append(line);
                writeLines.append("\n");
            }
            fileWriter.write(writeLines.toString());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed while saving config. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            return false;
        }
    }

    private static String join(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static ConfigConverter getConverter(Class<?> type) {
        for (ConfigConverter converter : converters) {
            if (!converter.supports(type)) continue;
            return converter;
        }
        Elevators.getElevatorsLogger().warning("Failed to find config converter for type: " + type.getName());
        return null;
    }

    public abstract ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> var1, String var2, Object var3, FieldData var4) throws Exception;

    public abstract Object serializeNodeToObject(ConfigNode<?> var1) throws Exception;

    public abstract Object serializeValueToObject(Object var1) throws Exception;

    public abstract boolean supports(Class<?> var1);

    public abstract String getFieldDisplay(ConfigNode<?> var1);

    public ConfigNode<?> createNodeWithData(ConfigNode<?> parentNode, String key, Object object, @Nullable Field field) {
        if (field == null) {
            return new DirectConfigNode<Object>(parentNode, key, object);
        }
        return new ClassicConfigNode<Object>(parentNode, field, object);
    }

    static {
        try {
            ConfigConverter.addConverter(PrimitiveConfigConverter.class);
            ConfigConverter.addConverter(ConfigConfigConverter.class);
            ConfigConverter.addConverter(ListConfigConverter.class);
            ConfigConverter.addConverter(MapConfigConverter.class);
            ConfigConverter.addConverter(ArrayConfigConverter.class);
            ConfigConverter.addConverter(SetConfigConverter.class);
            ConfigConverter.addConverter(MaterialConfigConverter.class);
            ConfigConverter.addConverter(EnumConfigConverter.class);
            ConfigConverter.addConverter(RecipeRowConfigConverter.class);
            ConfigConverter.addConverter(NamespacedKeyConfigConverter.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        DumperOptions yamlOptions = new DumperOptions();
        yamlOptions.setIndent(2);
        yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        yamlOptions.setSplitLines(false);
        ElevatorsRepresenter yamlRepresenter = new ElevatorsRepresenter(yamlOptions);
        yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        yamlRepresenter.setPropertyUtils(new PropertyUtils(){

            protected Set<Property> createPropertySet(Class<?> type, BeanAccess bAccess) {
                return this.getPropertiesMap(type, bAccess).values().stream().filter(prop -> prop.isReadable() && (this.isAllowReadOnlyProperties() || prop.isWritable())).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        });
        yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(Elevators.getInstance().getClass().getClassLoader(), new LoaderOptions()), (Representer)yamlRepresenter, yamlOptions);
    }

    public static class FieldData {
        private final Field field;
        private final Class<?> fieldClass;
        private final Type fieldType;

        public FieldData(Field field, Class<?> fieldClass, Type fieldType) {
            this.field = field;
            this.fieldClass = fieldClass;
            this.fieldType = fieldType;
        }

        public FieldData(@Nonnull Field field) {
            this.field = field;
            this.fieldClass = field.getType();
            this.fieldType = field.getGenericType();
        }

        public Field getField() {
            return this.field;
        }

        public Class<?> getFieldClass() {
            return this.fieldClass;
        }

        public Type getFieldType() {
            return this.fieldType;
        }

        private String getRawTypeName(Type type) {
            if (type instanceof ParameterizedType) {
                Type raw = ((ParameterizedType)type).getRawType();
                return raw.getTypeName();
            }
            return type.getTypeName();
        }

        public FieldData[] getGenericData() throws ClassNotFoundException {
            ParameterizedType genericType;
            if (this.fieldClass.isArray()) {
                Class<?> component = this.fieldClass.getComponentType();
                return new FieldData[]{new FieldData(null, component, component)};
            }
            if (this.field != null) {
                if (!(this.field.getGenericType() instanceof ParameterizedType)) {
                    return null;
                }
                genericType = (ParameterizedType)this.field.getGenericType();
            } else if (this.fieldType instanceof ParameterizedType) {
                genericType = (ParameterizedType)this.fieldType;
            } else {
                return null;
            }
            ArrayList<FieldData> fieldDataList = new ArrayList<FieldData>();
            for (Type type : genericType.getActualTypeArguments()) {
                String typeName = this.getRawTypeName(type);
                Class<?> clazz = this.getClass().getClassLoader().loadClass(typeName);
                fieldDataList.add(new FieldData(null, clazz, type));
            }
            return fieldDataList.toArray(new FieldData[0]);
        }
    }
}

