/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.converter.PrimitiveConfigConverter;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class MapConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, ConfigConverter.FieldData fieldData) throws Exception {
        ConfigConverter valueConverter;
        LinkedHashMap mapObj = new LinkedHashMap();
        ConfigNode<?> myNode = this.createNodeWithData(parentNode, key, mapObj, fieldData.getField());
        ConfigConverter.FieldData[] fieldDataList = fieldData.getGenericData();
        ConfigConverter.FieldData keyFieldData = fieldDataList[0];
        ConfigConverter.FieldData valueFieldData = fieldDataList[1];
        ConfigConverter configConverter = valueConverter = valueFieldData.getFieldClass() != null ? MapConfigConverter.getConverter(valueFieldData.getFieldClass()) : null;
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Optional<Object> objectOpt;
                if (entry.getValue() == null) continue;
                ConfigNode<?> childNode = valueConverter != null ? valueConverter.deserializeNodeWithFieldAndObject(myNode, entry.getKey().toString(), entry.getValue(), valueFieldData) : this.createNodeWithData(myNode, entry.getKey().toString(), entry.getValue(), null);
                Object keyObj = null;
                if (keyFieldData.getFieldClass().isEnum() && (objectOpt = Arrays.stream(keyFieldData.getFieldClass().getEnumConstants()).filter(i -> i.toString().equalsIgnoreCase(entry.getKey().toString())).findFirst()).isPresent()) {
                    keyObj = objectOpt.get();
                }
                if (keyObj == null) {
                    keyObj = PrimitiveConfigConverter.createPrimitiveFromObj(keyFieldData.getFieldClass(), entry.getKey());
                }
                myNode.getChildren().add(childNode);
                mapObj.put(keyObj, childNode.getValue());
            }
        } else if (!(object instanceof ArrayList)) {
            Elevators.getElevatorsLogger().warning("An invalid value was entered for key: " + key + ". Expected Map or Empty Array.");
        }
        return myNode;
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        LinkedHashMap newMap = new LinkedHashMap();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.serializeNodeToObject(childNode);
            }
            newMap.put(childNode.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object serializeValueToObject(Object mapObj) throws Exception {
        if (!(mapObj instanceof Map)) {
            return new HashMap();
        }
        Map map = (Map)mapObj;
        LinkedHashMap newMap = new LinkedHashMap();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            ConfigConverter converter = ConfigConverter.getConverter(key.getClass());
            if (converter != null) {
                key = converter.serializeValueToObject(key);
            }
            if ((converter = ConfigConverter.getConverter(value.getClass())) != null) {
                value = converter.serializeValueToObject(value);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    @Override
    public boolean supports(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        return "Map";
    }
}

