/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.events.ElevatorRegisterSettingsEvent;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorSetting;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.settings.CanExplodeSetting;
import me.keehl.elevators.models.settings.CheckColorSetting;
import me.keehl.elevators.models.settings.CheckPermsSetting;
import me.keehl.elevators.models.settings.ClassCheckSetting;
import me.keehl.elevators.models.settings.DisplayNameSetting;
import me.keehl.elevators.models.settings.DyePermissionSetting;
import me.keehl.elevators.models.settings.HologramLinesSetting;
import me.keehl.elevators.models.settings.LoreLinesSetting;
import me.keehl.elevators.models.settings.MaxDistanceSetting;
import me.keehl.elevators.models.settings.MaxSolidBlocksSetting;
import me.keehl.elevators.models.settings.MaxStackSizeSetting;
import me.keehl.elevators.models.settings.StopObstructionSetting;
import me.keehl.elevators.models.settings.SupportDyingSetting;
import me.keehl.elevators.models.settings.UsePermissionSetting;
import me.keehl.elevators.util.InternalElevatorSettingType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class ElevatorSettingService {
    private static boolean initialized = false;
    private static boolean allowSelfRegister = false;
    private static final List<ElevatorSetting<?>> elevatorSettings = new ArrayList();

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        ElevatorSettingService.registerDefaultSettings();
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Setting service enabled. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
    }

    private static void registerDefaultSettings() {
        Elevators.pushAndHoldLog();
        allowSelfRegister = true;
        ElevatorSettingService.addSetting(new UsePermissionSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new DyePermissionSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new CanExplodeSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new CheckColorSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new CheckPermsSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new ClassCheckSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new DisplayNameSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new LoreLinesSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new MaxDistanceSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new MaxSolidBlocksSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new MaxStackSizeSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new StopObstructionSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new SupportDyingSetting(Elevators.getInstance()));
        ElevatorSettingService.addSetting(new HologramLinesSetting(Elevators.getInstance()));
        Elevators.popLog(logData -> Elevators.log("Registered " + elevatorSettings.size() + " settings. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
        allowSelfRegister = false;
        Bukkit.getPluginManager().callEvent((Event)new ElevatorRegisterSettingsEvent());
    }

    public static void addSetting(ElevatorSetting<?> setting) {
        if (setting.getPlugin().getName().equalsIgnoreCase(Elevators.getInstance().getName()) && !allowSelfRegister) {
            throw new RuntimeException("An invalid Plugin was provided when trying to register an Elevator Setting.");
        }
        for (ElevatorSetting<?> otherSetting : elevatorSettings) {
            if (!otherSetting.getSettingName().equalsIgnoreCase(setting.getSettingName())) continue;
            String message = otherSetting.getPlugin().getName().equalsIgnoreCase(Elevators.getInstance().getName()) ? "External elevator settings are not able to override default settings" : "An elevator setting with the key \"" + setting.getSettingName() + "\" was already registered by plugin: " + otherSetting.getPlugin().getName();
            throw new RuntimeException(message);
        }
        elevatorSettings.add(setting);
    }

    public static List<ElevatorSetting<?>> getElevatorSettings() {
        return new ArrayList(elevatorSettings);
    }

    public static Optional<ElevatorSetting<?>> getElevatorSetting(String settingsKey) {
        return elevatorSettings.stream().filter(s -> s.getSettingName().equalsIgnoreCase(settingsKey)).findFirst();
    }

    public static <T> T getElevatorSettingValue(Elevator elevator, String settingsKey) {
        Optional<ElevatorSetting<?>> setting = ElevatorSettingService.getElevatorSetting(settingsKey);
        if (!setting.isPresent()) {
            return null;
        }
        try {
            return (T)setting.get().getIndividualValue(elevator);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getElevatorSettingValue(ElevatorType elevatorType, String settingsKey) {
        Optional<ElevatorSetting<?>> setting = ElevatorSettingService.getElevatorSetting(settingsKey);
        if (!setting.isPresent()) {
            return null;
        }
        try {
            return (T)setting.get().getGlobalValue(elevatorType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getElevatorSettingValue(Elevator elevator, InternalElevatorSettingType settingsKey) {
        return ElevatorSettingService.getElevatorSettingValue(elevator, settingsKey.getSettingName());
    }

    public static <T> T getElevatorSettingValue(ElevatorType elevatorType, InternalElevatorSettingType settingsKey) {
        return ElevatorSettingService.getElevatorSettingValue(elevatorType, settingsKey.getSettingName());
    }
}

