/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class ArrayConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, ConfigConverter.FieldData fieldData) throws Exception {
        ConfigConverter.FieldData childFieldData = fieldData.getGenericData()[0];
        if (childFieldData == null) {
            return null;
        }
        ConfigConverter converter = ConfigConverter.getConverter(childFieldData.getFieldClass());
        ArrayList currentValues = new ArrayList(object instanceof List ? (List<Object>)object : Arrays.asList((Object[])object));
        ArrayList values = new ArrayList();
        ArrayList childrenNodes = new ArrayList();
        for (Object obj : currentValues) {
            if (converter != null) {
                ConfigNode<?> childNode = converter.deserializeNodeWithFieldAndObject(parentNode, obj.toString(), obj, childFieldData);
                values.add(childNode.getValue());
                childrenNodes.add(childNode);
                continue;
            }
            childrenNodes.add(ConfigConverter.createNodeWithData(parentNode, obj.toString(), obj, null));
        }
        ConfigNode<?> myNode = ArrayConfigConverter.createNodeWithData(parentNode, key, values.toArray(), fieldData.getField());
        myNode.getChildren().addAll(childrenNodes);
        return myNode;
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        ArrayList values = new ArrayList();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.serializeNodeToObject(childNode);
            }
            values.add(value);
        }
        return values;
    }

    private Object[] convertToObjectArray(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    @Override
    public Object serializeValueToObject(Object arrayObj) throws Exception {
        Object[] array = this.convertToObjectArray(arrayObj);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object item : array) {
            ConfigConverter converter = ConfigConverter.getConverter(item.getClass());
            if (converter != null) {
                item = converter.serializeValueToObject(item);
            }
            values.add(item);
        }
        return values;
    }

    @Override
    public boolean supports(Class<?> type) {
        return type.isArray();
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            ClassicConfigNode classicNode = (ClassicConfigNode)node;
            Class<?> singleType = classicNode.getField().getType().getComponentType();
            return singleType.getSimpleName() + " Array";
        }
        return "Array";
    }
}

