/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators;

import com.tcoded.folialib.FoliaLib;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorCommandService;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorEffectService;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorListenerService;
import me.keehl.elevators.services.ElevatorObstructionService;
import me.keehl.elevators.services.ElevatorRecipeService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.ElevatorUpdateService;
import me.keehl.elevators.services.ElevatorVersionService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Elevators {
    protected static JavaPlugin instance;
    protected static FoliaLib foliaLib;
    protected static boolean initialized;
    private static final LogStack mainLogStack;

    protected static void enable(JavaPlugin plugin, FoliaLib foliaLib) {
        instance = plugin;
        Elevators.foliaLib = foliaLib;
        Elevators.pushAndHoldLog();
        ElevatorDataContainerService.init();
        ElevatorSettingService.init();
        ElevatorVersionService.init();
        ElevatorEffectService.init();
        ElevatorActionService.init();
        ElevatorTypeService.init();
        ElevatorRecipeService.init();
        ElevatorObstructionService.init();
        ElevatorListenerService.init();
        ElevatorHookService.init();
        ElevatorHologramService.init();
        ElevatorCommandService.init();
        ElevatorUpdateService.init(plugin.getDescription().getVersion());
        Elevators.popLog(logData -> Elevators.log("Services enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        Elevators.reloadElevators();
        initialized = true;
    }

    public static void disable() {
        Elevators.log("Disabling services");
        Elevators.pushLog();
        ElevatorHookService.unInitialize();
        ElevatorListenerService.unInitialize();
        ElevatorHologramService.onDisable();
        ElevatorUpdateService.unInitialize();
        Elevators.saveConfig();
        initialized = false;
        Elevators.popLog();
    }

    public static void saveConfig() {
        File configFile = new File(instance.getDataFolder(), "config.yml");
        ElevatorConfigService.saveConfig(configFile);
    }

    public static void reloadElevators() {
        boolean alreadyLoadedBefore = ElevatorConfigService.isConfigLoaded();
        Elevators.pushAndHoldLog();
        File configFile = new File(instance.getDataFolder(), "config.yml");
        instance.saveDefaultConfig();
        ElevatorConfigService.loadConfig(configFile);
        Elevators.saveConfig();
        Elevators.popLog(logData -> Elevators.log("Elevators " + (alreadyLoadedBefore ? "re" : "") + "loaded. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static JavaPlugin getInstance() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return (JavaPlugin)plugin;
        }
        return instance;
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public static File getConfigDirectory() {
        File configDirectory;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin == null) {
            plugin = Bukkit.getPluginManager().getPlugins()[0];
            configDirectory = new File(plugin.getDataFolder().getParent(), "Elevators");
        } else {
            configDirectory = plugin.getDataFolder();
        }
        try {
            configDirectory.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDirectory;
    }

    public static Logger getElevatorsLogger() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return plugin.getLogger();
        }
        return Bukkit.getLogger();
    }

    public static void log(String message) {
        if ((message = mainLogStack.log(message)) == null) {
            return;
        }
        Elevators.getElevatorsLogger().info(message);
    }

    public static void pushLog() {
        mainLogStack.push();
    }

    public static LogReleaseData popLog(Consumer<LogReleaseData> onPop) {
        LogReleaseData releaseData = mainLogStack.pop();
        if (onPop != null) {
            onPop.accept(releaseData);
        }
        for (String message : releaseData.getLogs()) {
            Elevators.log(message);
        }
        return releaseData;
    }

    public static LogReleaseData popLog() {
        return Elevators.popLog(null);
    }

    public static void holdLog() {
        mainLogStack.holdLogs();
    }

    public static void pushAndHoldLog() {
        Elevators.pushLog();
        Elevators.holdLog();
    }

    public static LogReleaseData releaseLog(Consumer<LogReleaseData> onRelease) {
        LogReleaseData released = mainLogStack.releaseLogs();
        if (onRelease != null) {
            onRelease.accept(released);
        }
        for (String message : released.getLogs()) {
            Elevators.log(message);
        }
        return released;
    }

    public static LogReleaseData releaseLog() {
        return Elevators.releaseLog(null);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
        mainLogStack = new LogStack();
    }

    public static class LogStack {
        private List<String> heldMessages;
        private LogStack child;
        private long holdStart = -1L;

        public String log(String message) {
            if (this.child != null) {
                Object returnMessage = this.child.log(message);
                if (returnMessage == null) {
                    return null;
                }
                returnMessage = "\t" + (String)returnMessage;
                if (this.heldMessages != null) {
                    this.heldMessages.add((String)returnMessage);
                    return null;
                }
                return returnMessage;
            }
            if (this.heldMessages != null) {
                this.heldMessages.add(message);
                return null;
            }
            return message;
        }

        public void push() {
            if (this.child != null) {
                this.child.push();
                return;
            }
            this.child = new LogStack();
        }

        public LogReleaseData pop() {
            if (this.child != null) {
                boolean noGrandChild = this.child.child == null;
                LogReleaseData logs = this.child.pop();
                if (noGrandChild) {
                    this.child = null;
                }
                return logs;
            }
            return this.releaseLogs();
        }

        public void holdLogs() {
            if (this.child != null) {
                this.child.holdLogs();
                return;
            }
            this.holdStart = System.currentTimeMillis();
            this.heldMessages = new ArrayList<String>();
        }

        public LogReleaseData releaseLogs() {
            if (this.child != null) {
                LogReleaseData childLogs = this.child.releaseLogs();
                if (this.heldMessages != null) {
                    this.heldMessages.addAll(childLogs.messages);
                    return null;
                }
                return childLogs;
            }
            ArrayList<String> logs = new ArrayList<String>();
            if (this.heldMessages != null) {
                for (String heldMessage : this.heldMessages) {
                    logs.add("\t" + heldMessage);
                }
            }
            this.heldMessages = null;
            long elapsed = System.currentTimeMillis() - (this.holdStart == -1L ? System.currentTimeMillis() : this.holdStart);
            return new LogReleaseData(elapsed, logs);
        }
    }

    public static class LogReleaseData {
        private final long elapsed;
        private final List<String> messages;

        protected LogReleaseData(long elapsed, List<String> messages) {
            this.elapsed = elapsed;
            this.messages = messages;
        }

        public long getElapsedTime() {
            return this.elapsed;
        }

        public List<String> getLogs() {
            return this.messages;
        }
    }
}

