/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.TagHelper;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.util.BoundingBox;

public class VersionHelper {
    private static final Pattern majorMinorPatchBetaPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-[0-9A-Za-z-]+(?:\\.([0-9]*))?)?$");
    private static final Pattern majorMinorPattern = Pattern.compile("^(\\d+)\\.(\\d+)");
    private static final int supportedVersion = VersionHelper.getVersionID("1.13.2");
    private static final int hexVersion = VersionHelper.getVersionID("1.16.1");
    private static final int shulkerFacingUseAPI = VersionHelper.getVersionID("1.14.1");
    private static final int supportBlockBoundingBoxes = VersionHelper.getVersionID("1.17.1");
    private static final int supportNewBuildLimits = VersionHelper.getVersionID("1.18.1");
    private static final int shulkerOpenCloseUseAPI = VersionHelper.getVersionID("1.16.2");
    private static final int paperCollectItemEffect = VersionHelper.getVersionID("1.16.5");
    private static final int supportRemoveRecipe = VersionHelper.getVersionID("1.15.2");
    private static final int supportConsumerDropItem = VersionHelper.getVersionID("1.18.0");
    private static final int supportPredicateChunkEntityGrab = VersionHelper.getVersionID("1.16.5");
    private static final int supportAlphaColor = VersionHelper.getVersionID("1.17.0");
    private static final int slimeSizeMetaData = 0;
    private static final int currentVersionID = VersionHelper.getVersionID(Bukkit.getServer().getBukkitVersion());

    public static boolean isVersionUnsupported() {
        return currentVersionID < supportedVersion;
    }

    public static boolean doesVersionSupportHex() {
        return currentVersionID >= hexVersion;
    }

    public static boolean doesVersionSupportAlphaColor() {
        return currentVersionID >= supportAlphaColor;
    }

    public static boolean doesVersionSupportShulkerFacingAPI() {
        return currentVersionID >= shulkerFacingUseAPI;
    }

    public static boolean doesVersionSupportBlockBoundingBoxes() {
        return currentVersionID >= supportBlockBoundingBoxes;
    }

    public static boolean doesVersionSupportNewBuildLimits() {
        return currentVersionID >= supportNewBuildLimits;
    }

    public static boolean doesVersionSupportOpenCloseAPI() {
        return currentVersionID >= shulkerOpenCloseUseAPI;
    }

    public static boolean doesVersionSupportPaperCollectEffect() {
        return Elevators.getFoliaLib().isPaper() && currentVersionID >= paperCollectItemEffect;
    }

    public static boolean doesVersionSupportRemoveRecipe() {
        return currentVersionID >= supportRemoveRecipe;
    }

    public static boolean doesVersionSupportConsumerDropItem() {
        return currentVersionID >= supportConsumerDropItem;
    }

    public static boolean doesVersionSupportPredicateGetChunkEntities() {
        return currentVersionID >= supportPredicateChunkEntityGrab;
    }

    public static int getWorldMinHeight(World world) {
        block3: {
            if (VersionHelper.doesVersionSupportNewBuildLimits()) {
                try {
                    Method method = world.getClass().getMethod("getMinHeight", new Class[0]);
                    method.setAccessible(true);
                    return (Integer)method.invoke((Object)world, new Object[0]);
                }
                catch (Exception ignore) {
                    if (world.getEnvironment() != World.Environment.NORMAL) break block3;
                    return -64;
                }
            }
        }
        return 0;
    }

    public static <T extends Recipe & Keyed> void removeRecipe(T recipe) {
        if (VersionHelper.doesVersionSupportRemoveRecipe()) {
            try {
                Method method = Bukkit.getServer().getClass().getMethod("removeRecipe", NamespacedKey.class);
                method.setAccessible(true);
                method.invoke((Object)Bukkit.getServer(), ((Keyed)recipe).getKey());
                return;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        Iterator recipeIterator = Bukkit.getServer().recipeIterator();
        while (recipeIterator.hasNext()) {
            Keyed keyedRecipe;
            Recipe nextRecipe = (Recipe)recipeIterator.next();
            if (!(nextRecipe instanceof Keyed) || !(keyedRecipe = (Keyed)nextRecipe).getKey().toString().equalsIgnoreCase(((Keyed)recipe).getKey().toString())) continue;
            recipeIterator.remove();
        }
    }

    public static void closeShulkerBox(ShulkerBox box) {
        if (VersionHelper.doesVersionSupportOpenCloseAPI()) {
            try {
                Method method = box.getClass().getMethod("close", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)box, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void openShulkerBox(ShulkerBox box) {
        if (VersionHelper.doesVersionSupportOpenCloseAPI()) {
            try {
                Method method = box.getClass().getMethod("open", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)box, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void dropItem(World world, Location location, ItemStack itemStack, Consumer<Item> alterStackConsumer) {
        if (VersionHelper.doesVersionSupportConsumerDropItem()) {
            try {
                Method method = world.getClass().getMethod("dropItem", Location.class, ItemStack.class, alterStackConsumer.getClass());
                method.setAccessible(true);
                method.invoke((Object)world, location, itemStack, alterStackConsumer);
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        Item item = world.dropItem(location, itemStack);
        alterStackConsumer.accept(item);
    }

    public static Collection<BlockState> getShulkerBoxesInChunk(Chunk chunk) {
        Predicate<Block> predicate = block -> TagHelper.SHULKER_BOXES.isTagged((Keyed)block.getType());
        if (VersionHelper.doesVersionSupportPredicateGetChunkEntities()) {
            try {
                Method method = chunk.getClass().getMethod("getTileEntities", predicate.getClass(), Boolean.TYPE);
                method.setAccessible(true);
                return (Collection)method.invoke((Object)chunk, predicate, false);
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        BlockState[] states = Elevators.getFoliaLib().isPaper() ? chunk.getTileEntities(false) : chunk.getTileEntities();
        return Arrays.stream(states).filter(state -> predicate.test(state.getBlock())).collect(Collectors.toList());
    }

    public static Collection<BoundingBox> getBoundingBoxes(Block block) {
        BoundingBox originalBox;
        if (VersionHelper.doesVersionSupportBlockBoundingBoxes()) {
            try {
                Method getShapeMethod = block.getClass().getMethod("getCollisionShape", new Class[0]);
                getShapeMethod.setAccessible(true);
                Object voxelShape = getShapeMethod.invoke((Object)block, new Object[0]);
                Method getBoundingBoxesMethod = voxelShape.getClass().getMethod("getBoundingBoxes", new Class[0]);
                getBoundingBoxesMethod.setAccessible(true);
                return (Collection)getBoundingBoxesMethod.invoke(voxelShape, new Object[0]);
            }
            catch (Exception getShapeMethod) {
                // empty catch block
            }
        }
        double newMinX = (originalBox = block.getBoundingBox()).getMinX() < 0.0 ? 1.0 + originalBox.getMinX() % 1.0 : originalBox.getMinX() % 1.0;
        double newMinZ = originalBox.getMinZ() < 0.0 ? 1.0 + originalBox.getMinZ() % 1.0 : originalBox.getMinZ() % 1.0;
        double newMinY = originalBox.getMinY() < 0.0 ? 1.0 + originalBox.getMinY() % 1.0 : originalBox.getMinY() % 1.0;
        BoundingBox box = new BoundingBox(newMinX, newMinY, newMinZ, newMinX + originalBox.getWidthX(), newMinY + originalBox.getHeight(), newMinZ + originalBox.getWidthZ());
        return Collections.singletonList(box);
    }

    public static Color getDustColor(int color) {
        if (VersionHelper.doesVersionSupportAlphaColor()) {
            try {
                Method method = Color.class.getMethod("fromRGB", Integer.TYPE);
                method.setAccessible(true);
                return (Color)method.invoke(null, color);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Color.fromRGB((int)(color & 0xFFFFFF));
    }

    public static int getVersionID(String key) {
        byte minor;
        byte major;
        Matcher matcher = majorMinorPatchBetaPattern.matcher(key.toUpperCase());
        byte patch = 0;
        int beta = 127;
        if (matcher.find()) {
            major = Byte.parseByte(matcher.group(1));
            minor = Byte.parseByte(matcher.group(2));
            patch = Byte.parseByte(matcher.group(3));
            String betaStr = matcher.group(4);
            if (betaStr != null && !betaStr.isEmpty()) {
                beta = Byte.parseByte(matcher.group(4));
            }
        } else {
            matcher = majorMinorPattern.matcher(key.toUpperCase());
            if (!matcher.find()) {
                return -1;
            }
            major = Byte.parseByte(matcher.group(1));
            minor = Byte.parseByte(matcher.group(2));
        }
        int ID = major << 8;
        ID |= minor;
        ID <<= 8;
        return (ID |= patch) << 8 | beta;
    }
}

