/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.models.ElevatorEventExecutor;
import me.keehl.elevators.services.listeners.EntityEventExecutor;
import me.keehl.elevators.services.listeners.InventoryEventExecutor;
import me.keehl.elevators.services.listeners.PaperEventExecutor;
import me.keehl.elevators.services.listeners.WorldEventExecutor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElevatorListenerService {
    private static boolean initialized = false;
    private static Listener listener;

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        ElevatorListenerService.listener = new Listener(){};
        ElevatorListenerService.registerEventExecutor(InventoryOpenEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onInventoryOpen);
        ElevatorListenerService.registerEventExecutor(InventoryClickEvent.class, EventPriority.HIGHEST, InventoryEventExecutor::onClickStackHandler, true);
        ElevatorListenerService.registerEventExecutor(InventoryClickEvent.class, EventPriority.LOWEST, InventoryEventExecutor::updateStackOnClick, true);
        ElevatorListenerService.registerEventExecutor(PrepareAnvilEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onAnvilPrepare);
        ElevatorListenerService.registerEventExecutor(CraftItemEvent.class, EventPriority.NORMAL, InventoryEventExecutor::onCraft);
        ElevatorListenerService.registerEventExecutor(BlockPistonExtendEvent.class, EventPriority.NORMAL, WorldEventExecutor::onPistonExtend);
        ElevatorListenerService.registerEventExecutor(EntityExplodeEvent.class, EventPriority.NORMAL, WorldEventExecutor::onExplode);
        ElevatorListenerService.registerEventExecutor(BlockDispenseEvent.class, EventPriority.NORMAL, WorldEventExecutor::onDispenserPlace);
        ElevatorListenerService.registerEventExecutor(BlockDropItemEvent.class, EventPriority.LOWEST, WorldEventExecutor::onBlockBreak);
        ElevatorListenerService.registerEventExecutor(BlockPlaceEvent.class, EventPriority.HIGHEST, WorldEventExecutor::onBlockPlace);
        ElevatorListenerService.registerEventExecutor(ChunkLoadEvent.class, EventPriority.MONITOR, WorldEventExecutor::onChunkLoad);
        ElevatorListenerService.registerEventExecutor(ChunkUnloadEvent.class, EventPriority.HIGHEST, WorldEventExecutor::onChunkUnload);
        ElevatorListenerService.registerEventExecutor(PlayerJoinEvent.class, EventPriority.NORMAL, EntityEventExecutor::onJoin);
        ElevatorListenerService.registerEventExecutor(PlayerToggleSneakEvent.class, EventPriority.NORMAL, EntityEventExecutor::onSneak);
        ElevatorListenerService.registerEventExecutor(EntityPickupItemEvent.class, EventPriority.NORMAL, EntityEventExecutor::onPickup);
        ElevatorListenerService.registerEventExecutor(PlayerInteractEvent.class, EventPriority.HIGHEST, EntityEventExecutor::onRightClick);
        if (Elevators.getFoliaLib().isPaper()) {
            ElevatorListenerService.registerEventExecutor(PlayerJumpEvent.class, EventPriority.NORMAL, PaperEventExecutor::onJump, false);
            ElevatorListenerService.registerEventExecutor(InventoryMoveItemEvent.class, EventPriority.LOWEST, PaperEventExecutor::onHopperTake);
        } else {
            ElevatorListenerService.registerEventExecutor(PlayerMoveEvent.class, EventPriority.NORMAL, EntityEventExecutor::onJumpDefault, false);
            ElevatorListenerService.registerEventExecutor(InventoryMoveItemEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onHopperTake);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("CMI")) {
            try {
                Class<?> backpackOpenEventClass = Class.forName("com.Zrips.CMI.events.CMIBackpackOpenEvent");
                Method getShulkerBoxMethod = backpackOpenEventClass.getMethod("getShulkerBox", new Class[0]);
                getShulkerBoxMethod.setAccessible(true);
                Bukkit.getPluginManager().registerEvent(backpackOpenEventClass, ElevatorListenerService.listener, EventPriority.NORMAL, (listener, event) -> {
                    if (event.getClass() != backpackOpenEventClass) {
                        return;
                    }
                    try {
                        ItemStack item = (ItemStack)getShulkerBoxMethod.invoke((Object)event, new Object[0]);
                        if (ElevatorHelper.isElevator(item)) {
                            ((Cancellable)event).setCancelled(true);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }, (Plugin)Elevators.getInstance(), false);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Listener service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static void unInitialize() {
        if (listener != null) {
            HandlerList.unregisterAll((Listener)listener);
        }
        initialized = false;
    }

    public static <T extends Event> void registerEventExecutor(Class<T> clazz, EventPriority priority, ElevatorEventExecutor<T> executor, boolean ignoreCancelled) {
        Bukkit.getPluginManager().registerEvent(clazz, ElevatorListenerService.listener, priority, (listener, event) -> {
            if (clazz.isAssignableFrom(event.getClass())) {
                executor.execute(event);
            }
        }, (Plugin)Elevators.getInstance(), ignoreCancelled);
    }

    public static <T extends Event> void registerEventExecutor(Class<T> clazz, EventPriority priority, ElevatorEventExecutor<T> executor) {
        ElevatorListenerService.registerEventExecutor(clazz, priority, executor, false);
    }
}

