/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import com.tcoded.folialib.wrapper.task.WrappedTask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.ElevatorConfigService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ElevatorUpdateService {
    private static final String apiEndpoint = "https://hangar.papermc.io/api/v1/projects/Keehl/Elevators/latest?channel=";
    private static final String resourceURL = "https://hangar.papermc.io/Keehl/Elevators";
    private static WrappedTask task;
    private static int currentVersion;
    private static boolean updateAvailable;
    private static boolean checkBetaChannels;

    public static void init(String version) {
        Elevators.pushAndHoldLog();
        checkBetaChannels = version.contains("beta");
        currentVersion = VersionHelper.getVersionID(version);
        ElevatorConfigService.addConfigCallback(root -> {
            ElevatorUpdateService.unInitialize();
            if (root.updateCheckerEnabled) {
                task = Elevators.getFoliaLib().getScheduler().runTimerAsync(ElevatorUpdateService::checkUpdate, 60L, 72000L);
            }
        });
        Elevators.popLog(logData -> Elevators.log("Update service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static void unInitialize() {
        if (task != null) {
            task.cancel();
        }
        task = null;
    }

    private static void sendUpdateMessage(Player player) {
        if (player.hasPermission("elevators.updatenotify")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "ELEVATORS " + String.valueOf(ChatColor.WHITE) + "An update is available for Elevators at " + String.valueOf(ChatColor.GOLD) + resourceURL);
        }
    }

    public static void checkUpdate() {
        if (!updateAvailable) {
            int maxChannelID = -1;
            if (checkBetaChannels) {
                maxChannelID = Math.max(maxChannelID, ElevatorUpdateService.checkResource("PreRelease"));
            }
            if ((maxChannelID = Math.max(maxChannelID, ElevatorUpdateService.checkResource("Release"))) <= currentVersion) {
                return;
            }
            updateAvailable = true;
        }
        Bukkit.getOnlinePlayers().forEach(ElevatorUpdateService::sendUpdateMessage);
        Elevators.log("An update for Elevators is available at:");
        Elevators.log(resourceURL);
    }

    public static int checkResource(String channel) {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(apiEndpoint + channel).openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            return VersionHelper.getVersionID(raw);
        }
        catch (IOException e) {
            return -1;
        }
    }

    static {
        updateAvailable = false;
        checkBetaChannels = false;
    }
}

