/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ElevatorGUIHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorTypeService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElevatorCommand
implements CommandExecutor,
TabCompleter {
    private final String prefix = String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.BOLD) + "ELEVATORS " + String.valueOf(ChatColor.WHITE);

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("elevators")) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    this.reloadCommand(sender, args[0]);
                    return true;
                }
                if (args[0].equalsIgnoreCase("admin")) {
                    this.openAdmin(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("give")) {
                    switch (args.length) {
                        case 1: {
                            this.onCommand(sender, args[0]);
                            break;
                        }
                        case 2: {
                            this.onCommand(sender, args[0], args[1]);
                            break;
                        }
                        case 3: {
                            this.onCommand(sender, args[0], args[1], args[2].toUpperCase());
                            break;
                        }
                        case 4: {
                            this.onCommand(sender, args[0], args[1], args[2].toUpperCase(), args[3].toUpperCase());
                            break;
                        }
                        case 5: {
                            this.onCommand(sender, args[0], args[1], args[2].toUpperCase(), args[3].toUpperCase(), args[4]);
                            break;
                        }
                        default: {
                            boolean silent = args[5].equalsIgnoreCase("-s") || args[5].equalsIgnoreCase("-silent");
                            this.onCommand(sender, args[0], args[1], args[2].toUpperCase(), args[3].toUpperCase(), args[4], silent);
                        }
                    }
                    return true;
                }
            }
            sender.sendMessage(this.prefix + "Did you mean: ");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/elevators reload" + String.valueOf(ChatColor.WHITE) + "?");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/elevators admin" + String.valueOf(ChatColor.WHITE) + "?");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/elevators give <player> <type> [color] [amount] [silent]" + String.valueOf(ChatColor.WHITE) + "?");
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!command.getName().equalsIgnoreCase("elevators")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> finalReturn = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("reload", "give", "admin"));
        } else if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            for (String name : ElevatorTypeService.getExistingElevatorKeys()) {
                completions.add(name.toLowerCase());
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("give")) {
            for (DyeColor dye : DyeColor.values()) {
                completions.add(dye.toString().toLowerCase());
            }
        } else if (args.length == 5 && args[0].equalsIgnoreCase("give")) {
            completions.add("[amount]");
        } else if (args.length == 6 && args[0].equalsIgnoreCase("give")) {
            completions.add("-silent");
        }
        if (completions.isEmpty()) {
            return null;
        }
        for (String line : completions) {
            if (!line.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
            finalReturn.add(line);
        }
        return finalReturn;
    }

    private void reloadCommand(CommandSender sender, String reload) {
        if (sender.hasPermission("elevators.reload")) {
            Elevators.reloadElevators();
            sender.sendMessage(this.prefix + "Reloaded the Elevators config!");
        } else {
            MessageHelper.sendCantReloadMessage(sender, null);
        }
    }

    private void openAdmin(CommandSender sender) {
        if (!sender.hasPermission("elevators.admin")) {
            MessageHelper.sendCantAdministrateMessage(sender, null);
            return;
        }
        if (!(sender instanceof Player)) {
            Elevators.getElevatorsLogger().warning("This command can only be executed by players!");
        } else {
            ElevatorGUIHelper.openAdminMenu((Player)sender);
        }
    }

    private void onCommand(CommandSender sender, String give) {
        if (sender instanceof Player) {
            sender.sendMessage(this.prefix + "Please provide a player to give the Elevator to!");
        } else {
            Elevators.getElevatorsLogger().warning("Please provide more arguments! /elevators give <player> <elevator> [color] [amount]");
        }
    }

    private void onCommand(CommandSender sender, String give, String player) {
        sender.sendMessage(this.prefix + "Please provide an elevator type!");
    }

    private void onCommand(CommandSender sender, String give, String player, String name) {
        this.onCommand(sender, give, player, name, "WHITE");
    }

    private void onCommand(CommandSender sender, String give, String player, String name, String color) {
        this.onCommand(sender, give, player, name, color, "1");
    }

    private void onCommand(CommandSender sender, String give, String player, String name, String color, String stringAmount) {
        this.onCommand(sender, give, player, name, color, stringAmount, false);
    }

    private void onCommand(CommandSender sender, String give, String playerName, String name, String color, String stringAmount, boolean silent) {
        int amount;
        DyeColor dye;
        color = color.toUpperCase();
        if (!sender.hasPermission("elevators.give")) {
            MessageHelper.sendCantGiveMessage(sender, null);
            return;
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null || !player.isOnline()) {
            sender.sendMessage(this.prefix + "That player is offline or does not exist!");
            return;
        }
        try {
            dye = DyeColor.valueOf((String)color);
        }
        catch (Exception e) {
            sender.sendMessage(this.prefix + "Invalid color given!");
            return;
        }
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(name);
        if (elevatorType == null) {
            sender.sendMessage(this.prefix + "Invalid elevator type given!");
            return;
        }
        try {
            amount = Integer.parseInt(stringAmount);
            if (amount <= 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            sender.sendMessage(this.prefix + "Invalid amount given! Must be integer greater than zero.");
            return;
        }
        Map<ItemStack, Integer> leftover = ItemStackHelper.addElevatorToInventory(elevatorType, amount, ItemStackHelper.getVariant(Material.BLACK_SHULKER_BOX, dye), (Inventory)player.getInventory());
        if (leftover.isEmpty()) {
            if (!silent) {
                MessageHelper.sendGivenElevatorMessage((CommandSender)player, null);
            }
        } else {
            if (!silent) {
                MessageHelper.sendNotEnoughRoomGiveMessage((CommandSender)player, null);
            }
            leftover.keySet().forEach(item -> player.getWorld().dropItem(player.getLocation(), item));
        }
    }
}

