/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv5_2_0;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import me.keehl.elevators.util.config.Comments;
import me.keehl.elevators.util.config.Config;

public class ConfigElevatorType
implements Config {
    @Comments(value={"Control default setting values of the elevator type."})
    protected ConfigSettings settings = new ConfigSettings();
    @Comments(value={"Define actions that can be run on elevator usage.", "Default actions are:", "action-bar, boss-bar, command-console", "command-player, message-all, message-player", "sound, title, effect, cost, trigger-observer, charge-exp", "", "If you do not wish to use actions on use, you can either delete the actions section", "or set the \"up\" and \"down\" values to an empty array with \"[]\". PlaceholderAPI is supported.", "Some default effects are: \"arrow\",\"helix\", \"sparkles\"", "", "IF AN IDENTIFIER KEY HAS BEEN GENERATED, DO NOT MESS WITH IT OR INDIVIDUAL ELEVATOR DATA MAY BE LOST."})
    protected ConfigActions actions = new ConfigActions();
    @Comments(value={"Define elevator settings that should not be customizable by users.", "Available settings are:", "can-explode, check-color, check-perms, check-type, change-holo, stop-obstruction", "", "Custom actions may have their own settings that can be disabled through use of the action key, a forward-slash, and the setting name.", "Available action settings are:", "message-player/message, sound/sound, sound/volume, sound/pitch, title/title, title/subtitle, action-bar/message, boss-bar/message, effect/effect"})
    protected List<String> disabledSettings = Arrays.asList("change-holo", "sound/sound", "action-bar/message", "boss-bar/message", "message-player/message", "title/title", "title/subtitle", "effect/effect");
    @Comments(value={"Define recipes to craft an elevator type. If you do not wish to have any recipes, replace the section", "with an empty map by settings recipes to \"{}\". Example:", "recipes: {}"})
    protected Map<String, ElevatorRecipeGroup> recipes = new HashMap<String, ElevatorRecipeGroup>(){
        {
            this.put("classic", new ElevatorRecipeGroup());
        }
    };

    public String getDisplayName() {
        return this.settings.displayName;
    }

    public String getUsePermission() {
        return this.settings.usePermission;
    }

    public String getDyePermission() {
        return this.settings.dyePermission;
    }

    public int getMaxStackSize() {
        return this.settings.maxStackSize;
    }

    public List<String> getLore() {
        return this.settings.loreLines;
    }

    public int getMaxDistanceAllowedBetweenElevators() {
        return this.settings.maxDistance;
    }

    public int getMaxSolidBlocksAllowedBetweenElevators() {
        return this.settings.maxSolidBlocks;
    }

    public boolean checkDestinationElevatorType() {
        return this.settings.classCheck;
    }

    public boolean doesElevatorRequirePermissions() {
        return this.settings.checkPerms;
    }

    public boolean canElevatorExplode() {
        return this.settings.canExplode;
    }

    public boolean canElevatorBeDyed() {
        return this.settings.supportDying;
    }

    public boolean shouldStopObstructedTeleport() {
        return this.settings.stopObstruction;
    }

    public boolean shouldValidateSameColor() {
        return this.settings.checkColor;
    }

    public boolean shouldAllowIndividualEdit() {
        return this.settings.canEditIndividually;
    }

    public List<String> getDisabledSettings() {
        return this.disabledSettings;
    }

    public ConfigActions getActionsConfig() {
        return this.actions;
    }

    public Map<String, ElevatorRecipeGroup> getRecipeMap() {
        return this.recipes;
    }

    public List<String> getHolographicLines() {
        return this.settings.hologramLines;
    }

    public static class ConfigActions
    implements Config {
        public List<String> up = Collections.singletonList("sound: ENTITY_BLAZE_SHOOT pitch=2.0 volume=1.0");
        public List<String> down = Collections.singletonList("sound: ENTITY_BLAZE_SHOOT pitch=2.0 volume=1.0");
    }
}

