/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigRecipe;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.permissions.Permissible;

public class ElevatorRecipeGroup
extends ConfigRecipe {
    private transient String recipeKey;
    private transient ElevatorType elevatorType;
    private final transient List<ElevatorRecipe> recipeList = new ArrayList<ElevatorRecipe>();

    @Override
    public void setKey(String key) {
        this.recipeKey = key != null ? key.toUpperCase() : null;
    }

    public void load(ElevatorType elevatorType) {
        this.elevatorType = elevatorType;
        this.refreshRecipes();
    }

    public void refreshRecipes() {
        this.recipeList.clear();
        if (this.supportMultiColorMaterials) {
            for (DyeColor color : DyeColor.values()) {
                this.addRecipe(this.craftPermission + "." + color.toString().toLowerCase(), color);
            }
        } else {
            this.addRecipe(this.craftPermission, this.defaultOutputColor);
        }
    }

    public String getRecipeKey() {
        return this.recipeKey;
    }

    public boolean supportMultiColorOutput() {
        return this.supportMultiColorOutput;
    }

    public boolean supportMultiColorMaterials() {
        return this.supportMultiColorMaterials;
    }

    public <T extends Recipe & Keyed> boolean doesPermissibleHavePermissionForRecipe(Permissible permissible, T recipe) {
        if (!this.supportMultiColorMaterials) {
            return permissible.hasPermission(this.craftPermission);
        }
        if (permissible.hasPermission(this.craftPermission + ".*")) {
            return true;
        }
        return this.recipeList.stream().filter(i -> ((Keyed)recipe).getKey().equals((Object)i.getNamespacedKey())).anyMatch(i -> permissible.hasPermission(i.getPermission()));
    }

    public List<NamespacedKey> getNameSpacedKeys() {
        return this.recipeList.stream().map(ElevatorRecipe::getNamespacedKey).collect(Collectors.toList());
    }

    private void addRecipe(String permission, DyeColor dyeColor) {
        NamespacedKey namespacedKey = ElevatorDataContainerService.createKey(dyeColor.toString() + "_" + this.elevatorType.getTypeKey() + "_" + this.recipeKey + "_ELEVATOR");
        DyeColor elevatorColor = this.supportMultiColorOutput ? dyeColor : this.defaultOutputColor;
        ItemStack elevatorItemStack = ItemStackHelper.createItemStackFromElevatorType(this.elevatorType, elevatorColor);
        elevatorItemStack.setAmount(this.amount);
        ShapedRecipe shapedRecipe = new ShapedRecipe(namespacedKey, elevatorItemStack);
        String[] shape = new String[]{"", "", ""};
        ArrayList<Runnable> setIngredientRunnables = new ArrayList<Runnable>();
        char currentChar = 'A';
        int rowIndex = 0;
        for (List recipeRow : this.recipe) {
            for (NamespacedKey key : recipeRow) {
                Runnable addIncredientRunnable;
                ItemStack item = ElevatorHookService.createItemStackFromKey(key);
                if (item == null || item.getType().isAir()) {
                    int n = rowIndex;
                    shape[n] = shape[n] + " ";
                    continue;
                }
                char character = currentChar;
                int n = rowIndex;
                shape[n] = shape[n] + character;
                if (key.getNamespace().equalsIgnoreCase("minecraft")) {
                    addIncredientRunnable = () -> shapedRecipe.setIngredient(character, ItemStackHelper.getVariant(item.getType(), dyeColor));
                } else if (key.getNamespace().equalsIgnoreCase(Elevators.getInstance().getName().toLowerCase(Locale.ROOT))) {
                    ElevatorType type = ElevatorTypeService.getElevatorType(key.getKey());
                    if (type != null) {
                        type = ElevatorTypeService.getDefaultElevatorType();
                    }
                    ElevatorType finalType = type;
                    addIncredientRunnable = () -> shapedRecipe.setIngredient(character, ItemStackHelper.createItemStackFromElevatorType(finalType, dyeColor));
                } else {
                    addIncredientRunnable = () -> shapedRecipe.setIngredient(character, item);
                }
                setIngredientRunnables.add(addIncredientRunnable);
                currentChar = (char)(currentChar + '\u0001');
            }
            ++rowIndex;
        }
        shapedRecipe.shape(shape);
        setIngredientRunnables.forEach(Runnable::run);
        this.recipeList.add(new ElevatorRecipe(permission, namespacedKey, shapedRecipe));
        Bukkit.addRecipe((Recipe)shapedRecipe);
    }

    private static class ElevatorRecipe {
        private final String permission;
        private final NamespacedKey namespacedKey;
        private final ShapedRecipe recipe;

        public ElevatorRecipe(String permission, NamespacedKey namespacedKey, ShapedRecipe recipe) {
            this.permission = permission;
            this.namespacedKey = namespacedKey;
            this.recipe = recipe;
        }

        public String getPermission() {
            return this.permission;
        }

        public NamespacedKey getNamespacedKey() {
            return this.namespacedKey;
        }

        public ShapedRecipe getRecipe() {
            return this.recipe;
        }
    }
}

