/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.versions.ElevatorsV1;
import me.keehl.elevators.services.versions.ElevatorsV2;
import me.keehl.elevators.services.versions.ElevatorsV3;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;

public class ElevatorVersionService {
    private static final List<ElevatorVersion> versions = new ArrayList<ElevatorVersion>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        versions.add(new ElevatorsV3());
        versions.add(new ElevatorsV2());
        versions.add(new ElevatorsV1());
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Version service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static ElevatorType getElevatorType(ItemStack item) {
        for (ElevatorVersion version : versions) {
            ElevatorType elevatorType = version.getElevatorType(item);
            if (elevatorType == null) continue;
            return elevatorType;
        }
        return null;
    }

    public static ElevatorType getElevatorType(ShulkerBox box, boolean updateBlock) {
        AbstractMap.SimpleEntry<Object, Object> result = new AbstractMap.SimpleEntry<Object, Object>(null, null);
        for (ElevatorVersion version : versions) {
            ElevatorType elevatorType = version.getElevatorType(box);
            if (elevatorType == null) continue;
            result = new AbstractMap.SimpleEntry<ElevatorType, Function<ShulkerBox, ShulkerBox>>(elevatorType, version::convertToLaterVersion);
        }
        if (result.getKey() == null) {
            return null;
        }
        if (updateBlock) {
            ShulkerBox newBox = (ShulkerBox)((Function)result.getValue()).apply(box);
            newBox = ShulkerBoxHelper.clearContents(newBox);
            if (ElevatorConfigService.getRootConfig().forceFacingUpwards) {
                ShulkerBoxHelper.setFacingUp(newBox);
            }
        }
        return (ElevatorType)result.getKey();
    }

    public static ElevatorType getElevatorType(Block block) {
        if (ItemStackHelper.isNotShulkerBox(block.getType())) {
            return null;
        }
        return ElevatorVersionService.getElevatorType(ShulkerBoxHelper.getShulkerBox(block), true);
    }

    public static abstract class ElevatorVersion {
        public abstract ElevatorType getElevatorType(ItemStack var1);

        public abstract ElevatorType getElevatorType(ShulkerBox var1);

        public abstract ElevatorType getElevatorType(Block var1);

        public abstract ShulkerBox convertToLaterVersion(ShulkerBox var1);

        protected ElevatorType getClassFromBoxName(String name) {
            if (name == null) {
                return null;
            }
            if (ElevatorTypeService.doesElevatorTypeExist(name)) {
                return ElevatorTypeService.getElevatorType(name);
            }
            return ElevatorTypeService.getDefaultElevatorType();
        }
    }
}

