/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import me.keehl.elevators.Elevators;

public class ResourceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportResource(Object clazz, String resourceName, String outputDirectory, String outputName, boolean overwrite) {
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = clazz.getClass().getResourceAsStream(resourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\"!");
            }
            byte[] buffer = new byte[63];
            String jarFolder = outputDirectory.replace('\\', '/');
            File returnFile = new File(jarFolder + File.separator + outputName);
            if (returnFile.exists() && !overwrite) {
                throw new Exception();
            }
            try {
                new File(jarFolder).mkdirs();
                returnFile.createNewFile();
            }
            catch (IOException ex) {
                throw new Exception("Error creating clone of resource!");
            }
            resStreamOut = Files.newOutputStream(returnFile.toPath(), new OpenOption[0]);
            while ((readBytes = stream.read(buffer)) != -1) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to export resource. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (resStreamOut != null) {
                    resStreamOut.close();
                }
            }
            catch (Exception e) {
                Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to close resource stream. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportResource(Object clazz, String resourceName, File outputFile, boolean overwrite) {
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = clazz.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\"!");
            }
            byte[] buffer = new byte[63];
            if (outputFile.exists() && !overwrite) {
                throw new Exception();
            }
            try {
                outputFile.getParentFile().mkdirs();
                outputFile.createNewFile();
            }
            catch (IOException ex) {
                throw new Exception("Error creating clone of resource!");
            }
            resStreamOut = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
            while ((readBytes = stream.read(buffer)) != -1) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to export resource. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (resStreamOut != null) {
                    resStreamOut.close();
                }
            }
            catch (Exception e) {
                Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to close resource stream. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            }
        }
    }

    public static String cleanTrace(Throwable ex) {
        ArrayList<String> traces = new ArrayList<String>();
        boolean continuation = false;
        for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("me.keehl.elevators") || stackTraceElement.getFileName() == null) {
                continuation = true;
                continue;
            }
            if (continuation) {
                traces.add("_");
                continuation = false;
            }
            traces.add(String.format("%s::%s:%d", stackTraceElement.getFileName().replace(".java", ""), stackTraceElement.getMethodName().replace("lambda$", "").replace("$1", ""), stackTraceElement.getLineNumber()));
        }
        Collections.reverse(traces);
        return "\t" + ex.getLocalizedMessage() + "\n\t" + String.join((CharSequence)" -> ", traces);
    }
}

