/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRecipe;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.permissions.Permissible;

public class ElevatorRecipeGroup
extends ConfigRecipe {
    private transient String recipeKey;
    private transient ElevatorType elevatorType;
    private final transient List<ElevatorRecipe> recipeList = new ArrayList<ElevatorRecipe>();

    @Override
    public void setKey(String key) {
        this.recipeKey = key != null ? key.toUpperCase() : null;
    }

    public void load(ElevatorType elevatorType) {
        this.elevatorType = elevatorType;
        this.refreshRecipes();
    }

    public void refreshRecipes() {
        this.recipeList.clear();
        if (this.supportMultiColorMaterials) {
            for (DyeColor color : DyeColor.values()) {
                this.addRecipe(this.craftPermission + "." + color.toString().toLowerCase(), color);
            }
        } else {
            this.addRecipe(this.craftPermission, this.defaultOutputColor);
        }
    }

    private Material getMaterialVariant(Material initialType, DyeColor color) {
        return ItemStackHelper.getVariant(initialType, color);
    }

    public String getRecipeKey() {
        return this.recipeKey;
    }

    public String getCraftPermission() {
        return this.craftPermission;
    }

    public Map<Character, Material> getMaterialMap() {
        return this.materials;
    }

    public List<String> getRecipe() {
        return this.recipe;
    }

    public boolean supportMultiColorOutput() {
        return this.supportMultiColorOutput;
    }

    public boolean supportMultiColorMaterials() {
        return this.supportMultiColorMaterials;
    }

    public <T extends Recipe & Keyed> boolean doesPermissibleHavePermissionForRecipe(Permissible permissible, T recipe) {
        if (!this.supportMultiColorMaterials) {
            return permissible.hasPermission(this.craftPermission);
        }
        if (permissible.hasPermission(this.craftPermission + ".*")) {
            return true;
        }
        return this.recipeList.stream().filter(i -> ((Keyed)recipe).getKey().equals((Object)i.getNamespacedKey())).anyMatch(i -> permissible.hasPermission(i.getPermission()));
    }

    public List<NamespacedKey> getNameSpacedKeys() {
        return this.recipeList.stream().map(ElevatorRecipe::getNamespacedKey).collect(Collectors.toList());
    }

    public DyeColor getDefaultOutputColor() {
        return this.defaultOutputColor;
    }

    private void addRecipe(String permission, DyeColor dyeColor) {
        NamespacedKey namespacedKey = ElevatorDataContainerService.createKey(dyeColor.toString() + "_" + this.elevatorType.getTypeKey() + "_" + this.recipeKey + "_ELEVATOR");
        DyeColor elevatorColor = this.supportMultiColorOutput ? dyeColor : this.defaultOutputColor;
        ItemStack elevatorItemStack = ItemStackHelper.createItemStackFromElevatorType(this.elevatorType, elevatorColor);
        elevatorItemStack.setAmount(this.amount);
        ShapedRecipe recipe = new ShapedRecipe(namespacedKey, elevatorItemStack);
        recipe.shape(this.recipe.toArray(new String[0]));
        Iterator iterator = this.materials.keySet().iterator();
        while (iterator.hasNext()) {
            char character = ((Character)iterator.next()).charValue();
            recipe.setIngredient(character, this.getMaterialVariant((Material)this.materials.get(Character.valueOf(character)), dyeColor));
        }
        this.recipeList.add(new ElevatorRecipe(permission, namespacedKey, recipe));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private static class ElevatorRecipe {
        private final String permission;
        private final NamespacedKey namespacedKey;
        private final ShapedRecipe recipe;

        public ElevatorRecipe(String permission, NamespacedKey namespacedKey, ShapedRecipe recipe) {
            this.permission = permission;
            this.namespacedKey = namespacedKey;
            this.recipe = recipe;
        }

        public String getPermission() {
            return this.permission;
        }

        public NamespacedKey getNamespacedKey() {
            return this.namespacedKey;
        }

        public ShapedRecipe getRecipe() {
            return this.recipe;
        }
    }
}

