/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.hooks;

import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ElevatorHook;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigHookData;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;

public abstract class ProtectionHook
implements ElevatorHook {
    private final String configKey;
    private final NamespacedKey containerKey;

    public ProtectionHook(String configKey) {
        this.configKey = configKey;
        this.containerKey = ElevatorDataContainerService.getKeyFromKey("protection-" + configKey, ElevatorDataContainerService.booleanPersistentDataType);
        ElevatorConfigService.addConfigCallback(root -> this.getConfig());
    }

    public ConfigHookData getConfig() {
        if (!ElevatorConfigService.getRootConfig().protectionHooks.containsKey(this.configKey)) {
            ElevatorConfigService.getRootConfig().protectionHooks.put(this.configKey, new ConfigHookData());
        }
        return ElevatorConfigService.getRootConfig().protectionHooks.get(this.configKey);
    }

    public boolean isCheckEnabled(Elevator elevator) {
        return ElevatorDataContainerService.getElevatorValue(elevator.getShulkerBox(), this.containerKey, this.getConfig().blockNonMemberUseDefault);
    }

    public void toggleCheckEnabled(Elevator elevator) {
        boolean currentValue = this.isCheckEnabled(elevator);
        ElevatorDataContainerService.setElevatorValue(elevator.getShulkerBox(), this.containerKey, !currentValue);
        elevator.getShulkerBox().update();
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public abstract void onProtectionClick(Player var1, Elevator var2, Runnable var3);

    public abstract boolean canEditName(Player var1, Elevator var2, boolean var3);

    public abstract boolean canEditSettings(Player var1, Elevator var2, boolean var3);
}

