/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import com.tcoded.folialib.wrapper.task.WrappedTask;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.hooks.WrappedHologram;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRoot;
import org.bukkit.Chunk;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ElevatorHologramService {
    private static boolean initialized = false;
    private static WrappedTask task;
    private static int currentIndex;

    public static void init() {
        if (initialized) {
            return;
        }
        ElevatorConfigService.addConfigCallback(ElevatorHologramService::onConfigReload);
        task = Elevators.getFoliaLib().getScheduler().runTimer(() -> {
            if (!ElevatorHologramService.canUseHolograms()) {
                return;
            }
            WrappedHologram[] holograms = ElevatorHookService.getHologramHook().getHolograms().toArray(new WrappedHologram[0]);
            if (holograms.length == 0) {
                return;
            }
            int attempts = 0;
            int startIndex = currentIndex;
            while (attempts++ < 10) {
                WrappedHologram hologram = holograms[currentIndex %= holograms.length];
                if (!hologram.getElevatorLocation().getChunk().isLoaded()) continue;
                hologram.update();
                if (startIndex != ++currentIndex) continue;
                return;
            }
        }, 5L, 5L);
        initialized = true;
    }

    public static void onDisable() {
        ElevatorHologramService.clearAll();
        task.cancel();
    }

    private static void onConfigReload(ConfigRoot config) {
    }

    public static WrappedHologram getElevatorHologramIfExists(Elevator elevator) {
        ShulkerBox shulkerBox = elevator.getShulkerBox();
        if (shulkerBox.hasMetadata("elevator-holo-uuid")) {
            String hologramUUID = ((MetadataValue)shulkerBox.getMetadata("elevator-holo-uuid").get(0)).asString();
            Object hologram = ElevatorHookService.getHologramHook().getHologram(hologramUUID);
            if (hologram != null) {
                return hologram;
            }
            shulkerBox.removeMetadata("elevator-holo-uuid", (Plugin)Elevators.getInstance());
        }
        return null;
    }

    public static WrappedHologram getElevatorHologram(Elevator elevator) {
        if (!ElevatorHologramService.canUseHolograms()) {
            return null;
        }
        WrappedHologram hologram = ElevatorHologramService.getElevatorHologramIfExists(elevator);
        if (hologram != null) {
            return hologram;
        }
        ShulkerBox shulkerBox = elevator.getShulkerBox();
        hologram = ElevatorHookService.getHologramHook().createHologram(elevator, ElevatorHologramService::deleteHologram, new String[0]);
        shulkerBox.setMetadata("elevator-holo-uuid", (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)hologram.getUUID()));
        ElevatorHologramService.updateElevatorHologram(elevator);
        return hologram;
    }

    public static void deleteHologram(Elevator elevator) {
        WrappedHologram hologram = ElevatorHologramService.getElevatorHologram(elevator);
        if (hologram == null) {
            return;
        }
        hologram.delete();
    }

    public static void deleteHologramsInChunk(Chunk ignoredChunk) {
    }

    public static void updateHologramsInChunk(Chunk chunk) {
        if (!ElevatorHologramService.canUseHolograms()) {
            return;
        }
        Collection<BlockState> tileEntities = VersionHelper.getShulkerBoxesInChunk(chunk);
        for (BlockState state : tileEntities) {
            ShulkerBox box;
            ElevatorType elevatorType;
            if (!(state instanceof ShulkerBox) || (elevatorType = ElevatorHelper.getElevatorType(box = (ShulkerBox)state)) == null) continue;
            ElevatorHologramService.updateElevatorHologram(new Elevator(box, elevatorType));
        }
    }

    public static void updateElevatorHologram(Elevator elevator) {
        WrappedHologram hologram;
        if (!ElevatorHologramService.canUseHolograms()) {
            return;
        }
        if (elevator == null) {
            return;
        }
        List<String> hologramLines = elevator.getElevatorType().getHolographicLines().stream().map(i -> MessageHelper.formatPlaceholders(null, i)).collect(Collectors.toList());
        WrappedHologram wrappedHologram = hologram = hologramLines.isEmpty() ? ElevatorHologramService.getElevatorHologramIfExists(elevator) : ElevatorHologramService.getElevatorHologram(elevator);
        if (hologram == null) {
            return;
        }
        if (hologramLines.isEmpty()) {
            hologram.delete();
            return;
        }
        hologram.setLines(hologramLines);
        hologram.teleportTo(elevator.getLocation().clone().add(0.5, 1.5 + hologram.getHeight() / 2.0, 0.5));
    }

    public static void updateHologramsOfElevatorType(ElevatorType elevatorType) {
        List holograms = ElevatorHookService.getHologramHook().getHolograms().stream().filter(i -> i.getElevatorType().equals(elevatorType)).collect(Collectors.toList());
        for (WrappedHologram hologram : holograms) {
            hologram.update();
        }
    }

    private static void deleteHologram(WrappedHologram hologram) {
        Elevator elevator = hologram.getElevator();
        if (elevator != null && elevator.getShulkerBox() != null) {
            elevator.getShulkerBox().removeMetadata("elevator-holo-uuid", (Plugin)Elevators.getInstance());
        }
    }

    public static void clearAll() {
        if (!ElevatorHologramService.canUseHolograms()) {
            return;
        }
        ElevatorHookService.getHologramHook().clearAll();
    }

    public static boolean canUseHolograms() {
        return ElevatorHookService.getHologramHook() != null;
    }

    static {
        currentIndex = 0;
    }
}

